#!/bin/bash

wine_path="$HOME/.wine"

viewer_path="$wine_path/drive_c/users/$USER/AppData/Local/Take Control Viewer/"

echo "Removing $viewer_path" 

sudo rm -rf "$viewer_path"	

. ./protocolUnregister.sh

read -p "Do you want to remove wine? (y/n): " user_option

# Convert the response to lowercase
user_option=$(echo "$user_option" | tr '[:upper:]' '[:lower:]')

if [ "$user_option" = "y" ]; then
    echo "Removing wine..."

    echo "Wine path: $wine_path"

    if [ -d "$wine_path" ]; then 
        sudo rm -rf $wine_path
        if [ -x "$(command -v dnf)" ]; then
        sudo dnf remove wine*
        elif [ -x "$(command -v apt)" ]; then
        sudo apt remove wine* --purge
        fi
    else
        echo "Wine is not installed on the expected path. Please make sure that it wasn't already removed or is installed elsewhere."
        echo "If you removed the .wine directory manually, please run the following command: "
        echo " - Ubuntu: sudo apt remove wine* --purge"
        echo " - Fedora: sudo dnf remove wine*"
        exit 1
    fi

    echo "Wine succesfully removed. Please run the 'autoremove' command at your discretion to remove unnecessary packages."

elif [ "$user_option" = "n" ]; then
    echo "Wine will not be removed."
else
    echo "Invalid response. Please enter 'y' for yes or 'n' for no."
fi

sudo update-desktop-database /usr/share/applications/
