#!/bin/bash

echo "Welcome to the installation script for N-Central Viewer."
echo "This script will install wine and then run the N-Central Viewer installer. Please, follow the instructions carefully."

if [ -x "$(command -v wine)" ]; then
    echo "Wine is installed. Please make sure it is the latest version from winehq official repository."
    echo "If you are not sure, please uninstall wine and then run this script again."
    echo "WARNING: If you don't have the latest version, the N-Central Viewer may not work properly."
    read -p "Do you want to continue? (y/n): " user_option

    # Convert the response to lowercase
    user_option=$(echo "$user_option" | tr '[:upper:]' '[:lower:]')

    if [ "$user_option" = "y" ]; then
        will_install_wine=false
    else 
        echo "Aborting installation..."
        exit 1
    fi

else
    echo "Wine is not installed. Will be installed now."
    read -p "Do you want to continue? (y/n): " user_option

    # Convert the response to lowercase
    user_option=$(echo "$user_option" | tr '[:upper:]' '[:lower:]')

    if [ "$user_option" = "y" ]; then
        will_install_wine=true
    else 
        will_install_wine=false
        echo "Wine will not be installed."
        echo "Aborting installation..."
        exit 1
    fi
fi

if $will_install_wine; then
    # Fedora
    if [ -x "$(command -v dnf)" ]; then

        # Get Fedora version number 
        if [ -f "/etc/fedora-release" ]; then
            source /etc/os-release
            fedora_version=$VERSION_ID
            if [ -n "$fedora_version" ]; then
                echo "Fedora Version: $fedora_version"
            else
                echo "Fedora version information not found in /etc/fedora-release."
                echo "Please install wine manually. Check official website"
                exit 1
            fi
        else
            echo "/etc/fedora-release file not found. Not a Fedora-based system."
            echo "Please install wine manually. Check official website"
            exit 1
        fi

        if [[ $fedora_version -lt 41 ]]; then
            sudo dnf config-manager --add-repo https://dl.winehq.org/wine-builds/fedora/$fedora_version/winehq.repo
        else
            sudo dnf5 config-manager addrepo --from-repofile=https://dl.winehq.org/wine-builds/fedora/$fedora_version/winehq.repo
        fi

        sudo dnf install winehq-stable

    # Ubuntu
    elif [ -x "$(command -v apt)" ]; then
        # Get Linux distribution codename
        codename=$(lsb_release -c -s)

        # Print the codename
        echo "Getting wine for $codename"
    
        # Add 32-bit architecture
        sudo dpkg --add-architecture i386
        # Add wine repository
        sudo mkdir -pm755 /etc/apt/keyrings
        sudo wget -O /etc/apt/keyrings/winehq-archive.key https://dl.winehq.org/wine-builds/winehq.key
        sudo wget -NP /etc/apt/sources.list.d/ https://dl.winehq.org/wine-builds/ubuntu/dists/$codename/winehq-$codename.sources
        # Install
        sudo apt update
        sudo apt install --install-recommends winehq-stable
    else
        echo "Unsupported distribution. Please install Wine manually. Check official website"
        exit 1
    fi
else
    echo "Wine is already installed. Continuing..."
fi

# Check Wine installation
if [ -x "$(command -v wine)" ]; then
    echo "Installing viewer..."
    wine MSPA4NCentralViewerInstall*.exe
    echo "N-Central viewer is installed" 
    . ./protocolRegister.sh
else
    echo "There were errors installing wine, please check official website and follow their steps. After that, run the following command to install the N-Central Viewer: wine MSPA4NCentralViewerInstall-X.xx.xx.exe"
fi
