#!/bin/bash

wine_path="/home/$USER/.wine/drive_c/users/$USER/AppData/Local/MSP Anywhere for N-central/Viewer"

if [ -d "$wine_path" ]; then
    echo "Viewer was successfully installed at $wine_path"
    echo "Creating integrated handlers..."

    appNames=("mspancsxvp" "tcancvp")

    for appName in "${appNames[@]}"; do
        appNameCaps=$(echo "$appName" | tr 'a-z' 'A-Z')
        executionPath="\"$wine_path/NCentralRDLdr.exe\""
        mimeType="x-scheme-handler/$appName"

        desktopFilePath="/usr/share/applications/$appName.desktop"

        # Use sudo to write to /usr/share/applications and change permissions
        sudo bash <<EOL
            cat <<EOLEOF > "$desktopFilePath"
[Desktop Entry]
Name=$appNameCaps
Exec=wine $executionPath -- %u
Terminal=false
Type=Application
MimeType=$mimeType;
EOLEOF

            chmod +x "$desktopFilePath"
EOL

        echo "Desktop entry created at: $desktopFilePath"
    done
else
    echo "Wine path does not exist"
    exit 1
fi

sudo update-desktop-database /usr/share/applications/
